-- Skript zur Dokumentation einer Analyse gegen eine Zeitdimension.
-- Al Benutzer SCOTT ausführen

/* Erstellung einer materialisierten Sicht als Zeitdimensionstabelle */
create materialized view times
refresh complete on demand
start with sysdate
next add_months(trunc(sysdate, 'Y'), 12) + interval '1' hour
as
select time_id, 
       to_char(time_id, 'Day', 'nls_date_language=German') day_name,
       to_number(to_char(time_id, 'D')) day_number_in_week,
       extract (day from time_id) day_number_in_month,
       to_number(to_char(time_id, 'IW')) calendar_week_number,
       next_day(time_id, 'Freitag') week_ending_day,
       extract (month from time_id) calendar_month_number,
       extract (day from last_day(time_id)) days_in_cal_month,
       last_day(time_id) end_of_cal_month,
       to_char(time_id, 'Month', 'nls_date_language=German') calendar_month_name,
       add_months(trunc(time_id, 'Q'), 3) - trunc(time_id, 'Q') days_in_cal_quarter,
       add_months(trunc(time_id, 'Q'), 3) - interval '1' day end_of_cal_quarter,
       to_number(to_char(time_id, 'Q')) calendar_quarter_number,
       extract (year from time_id) calendar_year,
       to_number(to_char(time_id, 'DDD')) days_in_cal_year,
       add_months(trunc(time_id, 'Y'), 12) - interval '1' day end_of_cal_year
  from (select add_months(trunc(sysdate, 'Y'), -120) + rownum - 1 time_id
          from all_objects
         where rownum <= add_months(trunc(sysdate, 'Y'), 12) - add_months(trunc(sysdate, 'Y'), -120));
 